<?php
session_start();
require 'db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];

    if (empty($username) || empty($email) || empty($password) || empty($confirm_password)) {
        $_SESSION['message'] = ["text" => "Visi lauki ir obligāti!", "type" => "error"];
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $_SESSION['message'] = ["text" => "Nepareizs e-pasta formāts!", "type" => "error"];
    } elseif ($password !== $confirm_password) {
        $_SESSION['message'] = ["text" => "Paroles nesakrīt!", "type" => "error"];
    } else {
        $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
        $stmt->execute([$email]);

        if ($stmt->fetch()) {
            $_SESSION['message'] = ["text" => "Šis e-pasts jau ir reģistrēts!", "type" => "error"];
        } else {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("INSERT INTO users (username, email, password_hash) VALUES (?, ?, ?)");
            
            if ($stmt->execute([$username, $email, $hashed_password])) {
                $_SESSION['message'] = ["text" => "Reģistrācija veiksmīga! Tagad vari pieslēgties.", "type" => "success"];
                header("Location: login.php");
                exit();
            } else {
                $_SESSION['message'] = ["text" => "Neizdevās reģistrēties!", "type" => "error"];
            }
        }
    }
}
?>

<?php include 'header.php'; ?>

<div class="form-container">
    <h2>Reģistrēties</h2>

    <?php include 'messages.php'; ?>

    <form method="POST">
        <label for="username">Lietotājvārds:</label>
        <input type="text" id="username" name="username" required>

        <label for="email">E-pasts:</label>
        <input type="email" id="email" name="email" required>

        <label for="password">Parole:</label>
        <input type="password" id="password" name="password" required>

        <label for="confirm_password">Apstiprināt paroli:</label>
        <input type="password" id="confirm_password" name="confirm_password" required>

        <button type="submit">Reģistrēties</button>
    </form>

    <p>Jau ir konts? <a href="login.php">Pieslēgties</a></p>
</div>

<?php include 'footer.php'; ?>
